/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq.trim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.usadellab.trimmomatic.fasta.FastaParser;
import org.usadellab.trimmomatic.fasta.FastaRecord;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.fastq.trim.Trimmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlluminaClippingTrimmer
implements Trimmer {
    public static final String PREFIX = "Prefix";
    public static final String SUFFIX_F = "/1";
    public static final String SUFFIX_R = "/2";
    public static final int MIN_PREFIX = 8;
    public static final int INTERLEAVE = 4;
    private static final float LOG10_4 = 0.60206f;
    private int seedMaxMiss;
    private int minPalindromeLikelihood;
    private int minSequenceLikelihood;
    private List<IlluminaPrefixPair> prefixPairs;
    private Set<IlluminaClippingSeq> forwardSeqs;
    private Set<IlluminaClippingSeq> reverseSeqs;
    private Set<IlluminaClippingSeq> commonSeqs;
    private static final int BASE_A = 1;
    private static final int BASE_C = 4;
    private static final int BASE_G = 8;
    private static final int BASE_T = 2;

    public IlluminaClippingTrimmer(String args) throws IOException {
        String[] arg = args.split(":");
        this.loadSequences(arg[0]);
        this.seedMaxMiss = Integer.parseInt(arg[1]);
        this.minPalindromeLikelihood = Integer.parseInt(arg[2]);
        this.minSequenceLikelihood = Integer.parseInt(arg[3]);
    }

    private void loadSequences(String seqPath) throws IOException {
        FastaParser parser = new FastaParser();
        parser.parse(new File(seqPath));
        HashMap<String, FastaRecord> forwardSeqMap = new HashMap<String, FastaRecord>();
        HashMap<String, FastaRecord> reverseSeqMap = new HashMap<String, FastaRecord>();
        HashMap<String, FastaRecord> commonSeqMap = new HashMap<String, FastaRecord>();
        HashSet<String> forwardPrefix = new HashSet<String>();
        HashSet<String> reversePrefix = new HashSet<String>();
        while (parser.hasNext()) {
            String clippedName;
            FastaRecord rec = parser.next();
            String name = rec.getName();
            if (name.endsWith(SUFFIX_F)) {
                forwardSeqMap.put(name, rec);
                if (!name.startsWith(PREFIX)) continue;
                clippedName = name.substring(0, name.length() - SUFFIX_F.length());
                forwardPrefix.add(clippedName);
                continue;
            }
            if (name.endsWith(SUFFIX_R)) {
                reverseSeqMap.put(name, rec);
                if (!name.startsWith(PREFIX)) continue;
                clippedName = name.substring(0, name.length() - SUFFIX_R.length());
                reversePrefix.add(clippedName);
                continue;
            }
            commonSeqMap.put(name, rec);
        }
        HashSet prefixSet = new HashSet(forwardPrefix);
        prefixSet.retainAll(reversePrefix);
        this.prefixPairs = new ArrayList<IlluminaPrefixPair>();
        for (String prefix : prefixSet) {
            String forwardName = prefix + SUFFIX_F;
            String reverseName = prefix + SUFFIX_R;
            FastaRecord forwardRec = (FastaRecord)forwardSeqMap.remove(forwardName);
            FastaRecord reverseRec = (FastaRecord)reverseSeqMap.remove(reverseName);
            this.prefixPairs.add(new IlluminaPrefixPair(forwardRec.getSequence(), reverseRec.getSequence()));
        }
        this.forwardSeqs = this.mapClippingSet(forwardSeqMap);
        this.reverseSeqs = this.mapClippingSet(reverseSeqMap);
        this.commonSeqs = this.mapClippingSet(commonSeqMap);
        System.out.println("ILLUMINACLIP: Using " + this.prefixPairs.size() + " prefix pairs, " + this.commonSeqs.size() + " forward/reverse sequences, " + this.forwardSeqs.size() + " forward only sequences, " + this.reverseSeqs.size() + " reverse only sequences");
    }

    private Set<IlluminaClippingSeq> mapClippingSet(Map<String, FastaRecord> map) {
        HashSet<IlluminaClippingSeq> out = new HashSet<IlluminaClippingSeq>();
        for (FastaRecord rec : map.values()) {
            out.add(new IlluminaClippingSeq(rec.getSequence()));
        }
        return out;
    }

    private Integer min(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a < b ? a : b;
    }

    @Override
    public FastqRecord[] processRecords(FastqRecord[] in) {
        FastqRecord forwardRec = null;
        FastqRecord reverseRec = null;
        if (in.length > 0) {
            forwardRec = in[0];
        }
        if (in.length > 1) {
            reverseRec = in[1];
        }
        Integer toKeepForward = null;
        Integer toKeepReverse = null;
        if (forwardRec != null && reverseRec != null) {
            for (IlluminaPrefixPair pair : this.prefixPairs) {
                Integer toKeep = this.palindromeReadsCompare(forwardRec, reverseRec, pair);
                if (toKeep == null) continue;
                toKeepForward = this.min(toKeepForward, toKeep);
                toKeepReverse = 0;
            }
        }
        if (forwardRec != null) {
            if (toKeepForward == null || toKeepForward > 0) {
                for (IlluminaClippingSeq seq : this.forwardSeqs) {
                    toKeepForward = this.min(toKeepForward, this.readsSeqCompare(forwardRec, seq));
                }
                for (IlluminaClippingSeq seq : this.commonSeqs) {
                    toKeepForward = this.min(toKeepForward, this.readsSeqCompare(forwardRec, seq));
                }
            }
            if (toKeepForward != null) {
                forwardRec = toKeepForward > 0 ? new FastqRecord(forwardRec, 0, toKeepForward) : null;
            }
        }
        if (reverseRec != null) {
            if (toKeepReverse == null || toKeepReverse > 0) {
                for (IlluminaClippingSeq seq : this.reverseSeqs) {
                    toKeepReverse = this.min(toKeepReverse, this.readsSeqCompare(reverseRec, seq));
                }
                for (IlluminaClippingSeq seq : this.commonSeqs) {
                    toKeepReverse = this.min(toKeepReverse, this.readsSeqCompare(reverseRec, seq));
                }
            }
            if (toKeepReverse != null) {
                reverseRec = toKeepReverse > 0 ? new FastqRecord(reverseRec, 0, toKeepReverse) : null;
            }
        }
        if (in.length == 2) {
            return new FastqRecord[]{forwardRec, reverseRec};
        }
        if (in.length == 1) {
            return new FastqRecord[]{forwardRec};
        }
        return new FastqRecord[0];
    }

    private Integer readsSeqCompare(FastqRecord rec, IlluminaClippingSeq clipSeq) {
        int seedMax = this.seedMaxMiss * 2;
        String recSequence = rec.getSequence();
        String clipSequence = clipSeq.getSeq();
        TreeSet<Integer> offsetSet = new TreeSet<Integer>();
        long[] packRec = IlluminaClippingTrimmer.packSeq(rec.getSequence(), false);
        long[] packClip = clipSeq.getPack();
        for (int i = 0; i < packRec.length; ++i) {
            for (int j = 0; j < packClip.length; ++j) {
                int diff = Long.bitCount(packRec[i] ^ packClip[j]);
                if (diff > seedMax) continue;
                int offset = i - j * 4;
                offsetSet.add(offset);
            }
        }
        for (Integer offset : offsetSet) {
            float seqLikelihood;
            int compLength = recSequence.length() - offset;
            if (clipSequence.length() < compLength) {
                compLength = clipSequence.length();
            }
            if (!((seqLikelihood = this.calculateDifferenceQuality(rec, clipSequence, compLength, offset)) >= (float)this.minSequenceLikelihood)) continue;
            return offset;
        }
        return null;
    }

    private float calculateDifferenceQuality(FastqRecord rec, String clipSeq, int overlap, int skip) {
        String seq = rec.getSequence();
        int[] quals = rec.getQualityAsInteger(true);
        int start = 0;
        if (skip < 0) {
            start = -skip;
        }
        float[] likelihood = new float[overlap - start];
        for (int i = start; i < overlap; ++i) {
            int offset = i + skip;
            char ch1 = seq.charAt(offset);
            char ch2 = clipSeq.charAt(i);
            likelihood[i - start] = ch1 == 'N' ? 0.0f : (ch1 != ch2 ? (float)(-quals[offset]) / 10.0f : 0.60206f);
        }
        float l = this.calculateMaximumRange(likelihood);
        return l;
    }

    private Integer palindromeReadsCompare(FastqRecord rec1, FastqRecord rec2, IlluminaPrefixPair pair) {
        int seqlen2;
        int seedMax = this.seedMaxMiss * 2;
        long[] pack1 = IlluminaClippingTrimmer.packSeq(pair.getPrefix1() + rec1.getSequence(), false);
        long[] pack2 = IlluminaClippingTrimmer.packSeq(pair.getPrefix2() + rec2.getSequence(), true);
        int prefixLength = pair.getPrefix1().length();
        int testIndex = 0;
        int refIndex = prefixLength;
        int count = 0;
        long ref1 = pack1[refIndex];
        long ref2 = pack2[refIndex];
        long test1 = pack1[testIndex];
        long test2 = pack2[testIndex];
        int seqlen1 = rec1.getSequence().length() + prefixLength;
        int maxCount = (seqlen1 > (seqlen2 = rec2.getSequence().length() + prefixLength) ? seqlen1 : seqlen2) - 15 - 8;
        while (refIndex < pack1.length && refIndex < pack2.length && count < maxCount) {
            ref1 = pack1[refIndex];
            ref2 = pack2[refIndex];
            test1 = pack1[testIndex];
            test2 = pack2[testIndex];
            int diff1 = Long.bitCount(ref1 ^ test2);
            int diff2 = Long.bitCount(ref2 ^ test1);
            if (diff1 <= seedMax || diff2 <= seedMax) {
                int actualOverlap;
                float palindromeLikelihood;
                int totalOverlap = count + prefixLength + 16;
                int skip1 = 0;
                int skip2 = 0;
                if (totalOverlap > seqlen1) {
                    skip2 = totalOverlap - seqlen1;
                }
                if (totalOverlap > seqlen2) {
                    skip1 = totalOverlap - seqlen2;
                }
                if ((palindromeLikelihood = this.calculatePalindromeDifferenceQuality(rec1, rec2, pair, actualOverlap = totalOverlap - skip1 - skip2, skip1, skip2)) >= (float)this.minPalindromeLikelihood) {
                    return totalOverlap - prefixLength * 2;
                }
            }
            if ((++count & 1) == 0) {
                ++refIndex;
                continue;
            }
            ++testIndex;
        }
        return null;
    }

    private char compCh(char ch) {
        switch (ch) {
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
        }
        return 'N';
    }

    private float calculatePalindromeDifferenceQuality(FastqRecord rec1, FastqRecord rec2, IlluminaPrefixPair pair, int overlap, int skip1, int skip2) {
        String seq1 = rec1.getSequence();
        String seq2 = rec2.getSequence();
        String prefix1 = pair.getPrefix1();
        String prefix2 = pair.getPrefix2();
        int[] quals1 = rec1.getQualityAsInteger(true);
        int[] quals2 = rec2.getQualityAsInteger(true);
        int prefixLength = prefix1.length();
        float[] likelihood = new float[overlap];
        for (int i = 0; i < overlap; ++i) {
            int qual2;
            int offset1 = i + skip1;
            int offset2 = skip2 + overlap - i - 1;
            char ch1 = offset1 < prefixLength ? prefix1.charAt(offset1) : seq1.charAt(offset1 - prefixLength);
            char ch2 = offset2 < prefixLength ? prefix2.charAt(offset2) : seq2.charAt(offset2 - prefixLength);
            ch2 = this.compCh(ch2);
            int qual1 = offset1 < prefixLength ? 100 : quals1[offset1 - prefixLength];
            int n = qual2 = offset2 < prefixLength ? 100 : quals2[offset2 - prefixLength];
            if (ch1 == 'N' || ch2 == 'N') {
                likelihood[i] = 0.0f;
                continue;
            }
            if (ch1 != ch2) {
                if (qual1 < qual2) {
                    likelihood[i] = -qual1 / 10;
                    continue;
                }
                likelihood[i] = -qual2 / 10;
                continue;
            }
            likelihood[i] = 0.60206f;
        }
        return this.calculateTotal(likelihood);
    }

    private float calculateMaximumRange(float[] vals) {
        ArrayList<Float> merges = new ArrayList<Float>();
        float total = 0.0f;
        for (float val : vals) {
            if (total > 0.0f && val < 0.0f || total < 0.0f && val > 0.0f) {
                merges.add(Float.valueOf(total));
                total = val;
            }
            total += val;
        }
        merges.add(Float.valueOf(total));
        boolean scanAgain = true;
        while (merges.size() > 0 && scanAgain) {
            ListIterator<Float> mergeIter = merges.listIterator();
            scanAgain = false;
            while (mergeIter.hasNext()) {
                float val = ((Float)mergeIter.next()).floatValue();
                if (!(val < 0.0f) || !mergeIter.hasPrevious() || !mergeIter.hasNext()) continue;
                float prev = ((Float)mergeIter.previous()).floatValue();
                mergeIter.next();
                float next = ((Float)mergeIter.next()).floatValue();
                if (prev > -val && next > -val) {
                    mergeIter.remove();
                    mergeIter.previous();
                    mergeIter.remove();
                    mergeIter.previous();
                    mergeIter.set(Float.valueOf(prev + val + next));
                    scanAgain = true;
                    continue;
                }
                mergeIter.previous();
            }
        }
        float max = 0.0f;
        Iterator i$ = merges.iterator();
        while (i$.hasNext()) {
            float val;
            val = ((Float)i$.next()).floatValue();
            if (!(val > max)) continue;
            max = val;
        }
        return total;
    }

    private float calculateTotal(float[] vals) {
        float total = 0.0f;
        for (float val : vals) {
            total += val;
        }
        return total;
    }

    public static long[] packSeq(String seq, boolean reverse) {
        long[] out = null;
        if (!reverse) {
            out = new long[seq.length() - 15];
            long pack = 0L;
            for (int i = 0; i < seq.length(); ++i) {
                int tmp = IlluminaClippingTrimmer.packCh(seq.charAt(i), false);
                pack = pack << 4 | (long)tmp;
                if (i < 15) continue;
                out[i - 15] = pack;
            }
        } else {
            out = new long[seq.length() - 15];
            long pack = 0L;
            for (int i = 0; i < seq.length(); ++i) {
                long tmp = IlluminaClippingTrimmer.packCh(seq.charAt(i), true);
                pack = pack >>> 4 | tmp << 60;
                if (i < 15) continue;
                out[i - 15] = pack;
            }
        }
        return out;
    }

    private static int packCh(char ch, boolean rev) {
        if (!rev) {
            switch (ch) {
                case 'A': {
                    return 1;
                }
                case 'C': {
                    return 4;
                }
                case 'G': {
                    return 8;
                }
                case 'T': {
                    return 2;
                }
            }
        } else {
            switch (ch) {
                case 'A': {
                    return 2;
                }
                case 'C': {
                    return 8;
                }
                case 'G': {
                    return 4;
                }
                case 'T': {
                    return 1;
                }
            }
        }
        return 0;
    }

    private static class IlluminaClippingSeq {
        private String seq;
        private long[] pack;

        private IlluminaClippingSeq(String seq) {
            this.seq = seq;
            long[] fullPack = IlluminaClippingTrimmer.packSeq(seq, false);
            this.pack = new long[(fullPack.length + 4 - 1) / 4];
            for (int i = 0; i < fullPack.length; i += 4) {
                this.pack[i / 4] = fullPack[i];
            }
        }

        public String getSeq() {
            return this.seq;
        }

        public long[] getPack() {
            return this.pack;
        }
    }

    private static class IlluminaPrefixPair {
        private String prefix1;
        private String prefix2;

        private IlluminaPrefixPair(String prefix1, String prefix2) {
            int length1 = prefix1.length();
            int length2 = prefix2.length();
            if (length1 != length2) {
                int minLength = length1;
                if (length2 < minLength) {
                    minLength = length2;
                }
                prefix1 = prefix1.substring(length1 - minLength);
                prefix2 = prefix2.substring(length2 - minLength);
            }
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
        }

        public String getPrefix1() {
            return this.prefix1;
        }

        public String getPrefix2() {
            return this.prefix2;
        }
    }
}

