/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fastq;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.usadellab.trimmomatic.fastq.FastqRecord;

public class FastqParser {
    private int phredOffset;
    private BufferedReader reader;
    private FastqRecord current;

    public FastqParser(int phredOffset) {
        this.phredOffset = phredOffset;
    }

    public void parseOne() throws IOException {
        this.current = null;
        String line = this.reader.readLine();
        if (line == null) {
            return;
        }
        if (!line.startsWith("@")) {
            throw new RuntimeException("Invalid FASTQ name line: " + line);
        }
        String name = line.substring(1);
        String sequence = this.reader.readLine();
        line = this.reader.readLine();
        if (!line.startsWith("+")) {
            throw new RuntimeException("Invalid FASTQ comment line: " + line);
        }
        String comment = line.substring(1);
        String quality = this.reader.readLine();
        this.current = new FastqRecord(name, sequence, comment, quality, this.phredOffset);
    }

    public void parse(File file) throws IOException {
        String name = file.getName();
        this.reader = name.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file), 1000000)))) : new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file), 1000000)));
        this.parseOne();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        return this.current != null;
    }

    public FastqRecord next() throws IOException {
        FastqRecord current = this.current;
        this.parseOne();
        return current;
    }
}

