/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic;

import java.text.DecimalFormat;
import org.usadellab.trimmomatic.fastq.FastqRecord;

public class TrimStats {
    private static DecimalFormat formatter = new DecimalFormat("0.00");
    private int input = 0;
    private int survivingBoth = 0;
    private int survivingForward = 0;
    private int survivingReverse = 0;

    public void merge(TrimStats other) {
        this.input += other.input;
        this.survivingBoth += other.survivingBoth;
        this.survivingForward += other.survivingForward;
        this.survivingReverse += other.survivingReverse;
    }

    public void logPair(FastqRecord[] originalRecs, FastqRecord[] recs) {
        if (originalRecs.length == 1) {
            if (originalRecs[0] != null) {
                ++this.input;
                if (recs[0] != null) {
                    ++this.survivingForward;
                }
            }
        } else if (originalRecs[0] != null && originalRecs[1] != null) {
            ++this.input;
            if (recs[0] != null) {
                if (recs[1] != null) {
                    ++this.survivingBoth;
                } else {
                    ++this.survivingForward;
                }
            } else if (recs[1] != null) {
                ++this.survivingReverse;
            }
        }
    }

    public String getStatsSE() {
        int dropped = this.input - this.survivingForward;
        double survivingForwardPercent = 100.0 * (double)this.survivingForward / (double)this.input;
        double droppedPercent = 100.0 * (double)dropped / (double)this.input;
        return "Input Reads: " + this.input + " Surviving: " + this.survivingForward + " (" + formatter.format(survivingForwardPercent) + "%) Dropped: " + dropped + " (" + formatter.format(droppedPercent) + "%)";
    }

    public String getStatsPE() {
        int dropped = this.input - this.survivingBoth - this.survivingForward - this.survivingReverse;
        double survivingBothPercent = 100.0 * (double)this.survivingBoth / (double)this.input;
        double survivingForwardPercent = 100.0 * (double)this.survivingForward / (double)this.input;
        double survivingReversePercent = 100.0 * (double)this.survivingReverse / (double)this.input;
        double droppedPercent = 100.0 * (double)dropped / (double)this.input;
        return "Input Reads: " + this.input + " Both Surviving: " + this.survivingBoth + " (" + formatter.format(survivingBothPercent) + "%) Forward Only Surviving: " + this.survivingForward + " (" + formatter.format(survivingForwardPercent) + "%) Reverse Only Surviving: " + this.survivingReverse + " (" + formatter.format(survivingReversePercent) + "%) Dropped: " + dropped + " (" + formatter.format(droppedPercent) + "%)";
    }
}

